import React from "react";
import { useAuth } from "../context/AuthContext";
import { Clock } from "lucide-react";
import Logo from "../image/Digital-Rackup-Logo.png";

export default function PendingApproval() {
    const { logout } = useAuth();

    return (
        <div style={{
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
            height: "100vh",
            padding: "1rem"
        }}>
            <div className="glass-panel" style={{
                padding: "3rem",
                width: "100%",
                maxWidth: "420px",
                display: "flex",
                flexDirection: "column",
                alignItems: "center",
                textAlign: "center"
            }}>
                <img src={Logo} alt="Logo" style={{ height: "48px", marginBottom: "2rem", opacity: 0.8 }} />

                <div style={{
                    background: "rgba(251, 191, 36, 0.1)",
                    padding: "1rem",
                    borderRadius: "50%",
                    marginBottom: "1.5rem",
                    border: "1px solid rgba(251, 191, 36, 0.2)"
                }}>
                    <Clock size={32} className="text-yellow-400" />
                </div>

                <h2 style={{ fontSize: "1.5rem", fontWeight: "700", marginBottom: "1rem" }}>Approval Pending</h2>

                <p style={{ color: "var(--text-muted)", marginBottom: "2rem", lineHeight: "1.6" }}>
                    Your account has been created and is awaiting administrator approval. You will receive access once approved.
                </p>

                <button onClick={logout} className="glass-button-secondary" style={{ width: "100%" }}>
                    Sign Out
                </button>
            </div>
        </div>
    );
}
